using System;
using System.Windows.Forms;
using DicomObjects;
using DicomObjects.EventArguments;

namespace SCU
{
	/// <summary>
	/// Summary description for Form1.
	/// </summary>
	public class Form1 : Form
	{
		internal TextBox TextBox1;
		internal TextBox Report;
		private Button SendSCPushBTN;
		private Timer tmr_dicom_connection;
		private System.ComponentModel.IContainer components;
		private DicomAssociation cn;
		private DicomServer Server;

		public Form1()
		{
			//
			// Required for Windows Form Designer support
			//
			InitializeComponent();
		}

		/// <summary>
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if (components != null) 
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}

		#region Windows Form Designer generated code
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
			this.components = new System.ComponentModel.Container();
			this.TextBox1 = new TextBox();
			this.Report = new TextBox();
			this.SendSCPushBTN = new Button();
			this.tmr_dicom_connection = new Timer(this.components);
			this.SuspendLayout();
			// 
			// TextBox1
			// 
			this.TextBox1.BackColor = System.Drawing.SystemColors.Control;
			this.TextBox1.BorderStyle = BorderStyle.None;
			this.TextBox1.Font = new System.Drawing.Font("Microsoft Sans Serif", 10F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.TextBox1.Location = new System.Drawing.Point(16, 16);
			this.TextBox1.Multiline = true;
			this.TextBox1.Name = "TextBox1";
			this.TextBox1.ReadOnly = true;
			this.TextBox1.Size = new System.Drawing.Size(712, 72);
			this.TextBox1.TabIndex = 9;
			this.TextBox1.Text = @"This simple example of storage commitment uses the now standard ""push"" model, and as is now regarded as best practice, expects to receive the acknowledgment on a separate association (thoug it will equally happily accept it on the original association if offered).  In order to receive a reversed role association request, it listens on port 105.  The Association is held open for 5 seconds to allow responses on the same connection if the SCP chooses so";
			// 
			// Report
			// 
			this.Report.BorderStyle = BorderStyle.FixedSingle;
			this.Report.Location = new System.Drawing.Point(192, 96);
			this.Report.Multiline = true;
			this.Report.Name = "Report";
			this.Report.ScrollBars = ScrollBars.Vertical;
			this.Report.Size = new System.Drawing.Size(536, 376);
			this.Report.TabIndex = 0;
			this.Report.Text = "";
			// 
			// SendSCPushBTN
			// 
			this.SendSCPushBTN.Location = new System.Drawing.Point(8, 96);
			this.SendSCPushBTN.Name = "SendSCPushBTN";
			this.SendSCPushBTN.Size = new System.Drawing.Size(168, 96);
			this.SendSCPushBTN.TabIndex = 12;
			this.SendSCPushBTN.Text = "Send Storage Commitment Push";
			this.SendSCPushBTN.Click += new System.EventHandler(this.SendSCPushBTN_Click);
			// 
			// tmr_dicom_connection
			// 
			this.tmr_dicom_connection.Interval = 4000;
			this.tmr_dicom_connection.Tick += new System.EventHandler(this.tmr_dicom_connection_Tick);
			// 
			// Form1
			// 
			this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
			this.ClientSize = new System.Drawing.Size(744, 486);
			this.Controls.Add(this.SendSCPushBTN);
			this.Controls.Add(this.Report);
			this.Controls.Add(this.TextBox1);
			this.Name = "Form1";
			this.Text = "Storage Commitment VB.NET Sample";
			this.Closing += new System.ComponentModel.CancelEventHandler(this.Form1_Closing);
			this.Load += new System.EventHandler(this.Form1_Load);
			this.ResumeLayout(false);

		}
		#endregion

		/// <summary>
		/// The main entry point for the application.
		/// </summary>
		[STAThread]
		static void Main() 
		{
			Application.Run(new Form1());
		}


		private void Form1_Load(object sender, EventArgs e)
		{
			Server = new DicomServer();
			Server.AssociationRequest +=Server_AssociationRequest;
			Server.N_Event_Report +=Server_N_Event_Report;
			Server.DefaultStatus = 0x110;
			Server.Listen(105);
            // Put the following in back in to enable DicomObjects logging
			// DicomObjects.DicomGlobal.LogToFile("c:\\dicom log files\\", 0x3F);
		}

		private void Form1_Closing(object sender, System.ComponentModel.CancelEventArgs e)
		{
			Server.UnlistenAll();
		}

		private void CloseOutgoingAssociation()
		{
			tmr_dicom_connection.Enabled = false;
			if(cn != null)
			{
				cn.Close();
			}
			cn = null;
			Log("Outgoing Association Closed Normally");
		}

		private void tmr_dicom_connection_Tick(object sender, EventArgs e)
		{
			CloseOutgoingAssociation();
		}

        private void Log(string s)
        {
            AppendText(Report, s);
        }

        delegate void SetTextCallback(TextBox box, string text);

        private void AppendText(TextBox box, string text)
        {
            // InvokeRequired required compares the thread ID of the
            // calling thread to the thread ID of the creating thread.
            // If these threads are different, it returns true.
            if (box.InvokeRequired)
            {
                SetTextCallback d = AppendText;
                Invoke(d, new object[] { box, text });
            }
            else
            {
                box.Text = box.Text + text + "\r\n";
            }
        }

		private void SendSCPushBTN_Click(object sender, EventArgs e)
		{

			/* STORAGE COMMITMENT REQUEST
			 
			Action Type/Name		Action Type ID		Attribute		Tag
			
			Request						
			Storage						   1		  TransactionUID (0008,1195)
			Commitment
													  Storage Media
                                                       File-Set ID   (0088,0130)
														
													  Storage Media
													   File-Set UID  (0088,0140)

													   Referenced
													       SOP
													    Sequence     (0008,1199)

													    >Referenced
													     SOP Class
													     UID           >(0008,1150)
														>Referenced
														SOP Instance
														UID			   >(0008,1155)
			 
			 */

			string[] offerTS = new string[2];
			offerTS[0] = "1.2.840.10008.1.2";
			offerTS[1] = "1.2.840.10008.1.2.1";

			// close possible previously opened association and create a new one
			CloseOutgoingAssociation();

			// Enable timer to close outgoing association after a time-out
			tmr_dicom_connection.Enabled = true;
			cn = new DicomAssociation();

			// Negotiate a suitable Association with Correct SOP Class
			cn.MetaSOPClass = DicomObjects.DicomUIDs.SOPClasses.StorageCommitmentPush;
			cn.RequestedContexts.Add(DicomObjects.DicomUIDs.SOPClasses.StorageCommitmentPush);
			cn.RequestedContexts[1].RequestorSCURole = true;
			cn.RequestedContexts[1].RequestorSCPRole = false;
			cn.RequestedContexts[1].OfferedTS = offerTS;

			cn.Open("localhost", 104, "SC_SCU", "SC_SCP");

			DicomDataSet ds = new DicomDataSet();
			DicomDataSet referencedImage1 = new DicomDataSet();
			DicomDataSet referencedImage2 = new DicomDataSet();
			DicomDataSetCollection referencedImagesSequence = new DicomDataSetCollection();			

			string instanceUID;

			// the next 3 lines could be repeated N times to send a request for N Images
			referencedImage1.Add(0x8, 0x1150,  "1.2.840.10008.5.1.4.1.1.7");	  // Referenced SOP Class UID
			instanceUID = DicomGlobal.NewUID();
			referencedImage1.Add(0x8, 0x1155, instanceUID); // Referenced SOP Instance UID, in reality this should be some existing Image Instance UID
			referencedImagesSequence.Add(referencedImage1);
			Log("Request for Image " + instanceUID + " added for storage commitment request.");

			// Add another image here
			referencedImage2.Add(0x8, 0x1150,  "1.2.840.10008.5.1.4.1.1.7");	  // Referenced SOP Class UID
			instanceUID = DicomGlobal.NewUID();
			referencedImage2.Add(0x8, 0x1155, instanceUID); // Referenced SOP Instance UID, in reality this should be some existing Image Instance UID
			referencedImagesSequence.Add(referencedImage2);
			Log("Request for Image " + instanceUID + " added for storage commitment request.");

			ds.Add(0x8, 0x1199, referencedImagesSequence); // Referenced SOP Sequence
			ds.Add(0x8, 0x1195, DicomGlobal.NewUID()); // Transaction UID
			
			Log("Sending storage commitment request - Transaction UID = " + ds[8, 0x1195].Value.ToString());

			// Send Storage Commitment Push
			cn.NAction(DicomObjects.DicomUIDs.SOPClasses.StorageCommitmentPush,DicomObjects.DicomUIDs.WellKnownInstances.StorageCommitmentPushModelInstance, 1,ds);
		}

		private void Server_AssociationRequest(object sender, AssociationRequestArgs e)
		{
			Log("Incoming Assocaiton Request from " + e.Association.CallingAET + "  at " + e.Association.RemoteIP);			
		}

		private void Server_N_Event_Report(object sender, N_Event_ReportArgs e)
		{
			string AffectedSOPInstanceUID = Convert.ToString(e.Command[0x0, 0x1000].Value);
			int CommandField = Convert.ToInt32(e.Command[0x0,0x0100].Value.ToString());
			int status = 0x110;

			if(CommandField != 0x100)
			{
				Log("Fatal Error");
			}
	
			if(AffectedSOPInstanceUID != DicomObjects.DicomUIDs.WellKnownInstances.StorageCommitmentPushModelInstance)
			{
				status = 0x112; // no such object instance
				Log("AffectedSOPInstanceUID not Correct");
			}

			if(cn == null)
			{
				Log("Response Received on New Association");
			}
			else
			{
			    Log(cn.AssociationNumber == e.RequestAssociation.AssociationNumber
			            ? "Response Received on Original Association"
			            : "Response Received on Different Association");
			}
			
			switch(e.EventID)
			{
				case 1 : // list all successful requests
					Log("Storage commitment succeeded for Transaction UID: " + e.Request[0x8, 0x1195].Value.ToString());
					DicomDataSetCollection dss = (DicomDataSetCollection)e.Request[0x8, 0x1199].Value;
					foreach(DicomDataSet ds in dss)
					{
                        Log("Succeeded Image Instance UID " + ds[0x8, 0x1155].Value.ToString());
					}
					break;
				case 2 : // list all successful requests as well as failed requests
					Log("Storage commitment failed for Transaction UID: " + e.Request[0x8, 0x1195].Value.ToString());
					DicomDataSetCollection dss1 = (DicomDataSetCollection)e.Request[0x8, 0x1199].Value;
					foreach(DicomDataSet ds in dss1)
					{
                        Log("Succeeded Image Instance UID " + ds[0x8, 0x1155].Value.ToString());
					}
					DicomDataSetCollection dss2 = (DicomDataSetCollection)e.Request[0x8, 0x1198].Value;
					foreach(DicomDataSet ds in dss2)
					{
						Log("Failed Image Instance UID " + ds[0x8, 0x1155].Value.ToString());
					}
					break;
				default:
					status = 0x123; // no such action type
					Log("Error - Wrong EventID Received");
					break;
			}
						
			e.Status = status;
		}
	}
}
